/***************************************************************************
 AQUnpacker.cpp
 -------------------
 begin                : 08/03/2011
 copyright            : (C) 2003-2011 by InfoSiAL S.L.
 email                : mail@infosial.com
 ***************************************************************************/
/***************************************************************************
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; version 2 of the License.               *
 ***************************************************************************/
/***************************************************************************
 Este  programa es software libre. Puede redistribuirlo y/o modificarlo
 bajo  los  trminos  de  la  Licencia  Pblica General de GNU   en  su
 versin 2, publicada  por  la  Free  Software Foundation.
 ***************************************************************************/

#include <qdir.h>
#include <errno.h>

#include "AQConfig.h"
#include "AQUnpacker.h"

AQUnpacker::AQUnpacker(const QString &input)
{
  file_ = new QFile(QDir::cleanDirPath(input));
  if (file_->open(IO_ReadOnly)) {
    stream_ = new QDataStream(file_);
    char *ver;
    (*stream_) >> ver;
    bool ok = AQPACKAGER_VERSION_CHECK(ver);
    if (!ok)
      errMsgs_ << QString().sprintf("'%s': No was generated by %s",
                                    input.latin1(), AQPACKAGER_VERSION);
    delete [] ver;
  } else
    AQ_STRERROR(input);
}

AQUnpacker::~AQUnpacker()
{
  delete stream_;
  delete file_;
}

QString AQUnpacker::getText() const
{
  QByteArray ba;
  (*stream_) >> ba;
  QTextIStream ti(qUncompress(ba));
  return ti.read();
}

QByteArray AQUnpacker::getBinary() const
{
  QByteArray ba;
  (*stream_) >> ba;
  return qUncompress(ba);
}

QStringList AQUnpacker::errorMessages() const
{
  return errMsgs_;
}

