/***************************************************************************
                                FLVar.h
                          -------------------
 begin                : Thu Jul 29 2004
 copyright            : (C) 2004-2005 by InfoSiAL S.L.,
 email                : mail@infosial.com
***************************************************************************/
/***************************************************************************
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; version 2 of the License.               *
 ***************************************************************************/
/***************************************************************************
   Este  programa es software libre. Puede redistribuirlo y/o modificarlo
   bajo  los  trminos  de  la  Licencia  Pblica General de GNU   en  su
   versin 2, publicada  por  la  Free  Software Foundation.
 ***************************************************************************/

#ifndef FLVAR_H
#define FLVAR_H

#include <qstring.h>

/**
Clase usada para crear, leer y borrar valores globales accesibles desde los scripts.

Esta clase mantiene una tabla (flvar) donde se guardan los determinados que hacen las veces
de variables globales de aplicacin desde los sctipts

@author InfoSiAL S.L.
*/
class FL_EXPORT FLVar
{

public:

  /**
  Establece un valor en la tabla de variables de sesin

  @param n Nombre de la variable
  @param v Valor asociado
  @return Verdadero en caso de establecer el valor con xito, falso en cualquier otro caso
  */
  static bool set(const QString &n, const QVariant &v);

  /**
  Lee un valor en la tabla de variables de sesin

  @param n Nombre de la variable a leer
  @return Valor asociado, en caso de leer el valor con xito, falso en cualquier otro caso
  */
  static QVariant get(const QString &n);

  /**
  Borra la variable de sesin

  @param n Nombre de la variable a borrar
  @return True si se borra correctamente, false en caso contrario
  */
  static bool del(const QString &n);

  /**
  Borra todas las variables correspondientes a una sesin

  @return Verdadero si el borrado se completa con xito, falso en otro caso
  */
  static bool clean();
};

#endif
