/***************************************************************************
                           FLFormRecordDB.h
                          -------------------
 begin                : Sat Jul 28 2001
 copyright            : (C) 2001-2005 by InfoSiAL S.L.
 email                : mail@infosial.com
***************************************************************************/
/***************************************************************************
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; version 2 of the License.               *
 ***************************************************************************/
/***************************************************************************
   Este  programa es software libre. Puede redistribuirlo y/o modificarlo
   bajo  los  trminos  de  la  Licencia  Pblica General de GNU   en  su
   versin 2, publicada  por  la  Free  Software Foundation.
 ***************************************************************************/

#ifndef FLFORMRECORDDB_H
#define FLFORMRECORDDB_H

#include <qpushbutton.h>
#include <qsqlrecord.h>
#include <qtooltip.h>
#include <qwhatsthis.h>

#include "FLFormDB.h"

class FLFormRecordDBInterface;

/**
Subclase de FLFormDB pensada para editar registros.

Bsicamente esta clase hace lo mismo que su clase
base FLFormDB, lo nico que aade son dos botones
Aceptar y/o Cancelar para confirmar o cancelar
los cambios que se realizan en los componentes de
datos que contiene.

Esta clase es idnea para cargar los formularios de
edicin de registros definidos en los metadatos
( FLTableMetaData ).

@author InfoSiAL S.L.
*/
class FLFormRecordDB: public FLFormDB
{
  Q_OBJECT

  friend class FLFormRecordDBInterface;

public:

  /**
  constructor.

  Solo acepta que se le indique un cursor ya creado.

  @param cursor Objeto FLSqlCursor con el cursor con el que tratar.
  @param actionName Nombre de la accin asociada al formulario
  @param showAcceptContinue Indica si se debe mostrar el botn de Aceptar y Continuar
  */
  FLFormRecordDB(FLSqlCursor *cursor, const QString &actionName = QString::null,
                 QWidget *parent = 0, bool showAcceptContinue = true);

  /**
  destructor
  */
  ~FLFormRecordDB();

  /**
  Establece el cursor que debe utilizar el formulario.

  @param c Cursor con el que trabajar
  */
  void setCursor(FLSqlCursor *c);

  /**
  Reimplementado, aade un widget como principal del formulario
  */
  void setMainWidget(QWidget *w);

  /**
  Sobrecargado de setMainWidget.

  Aqui toma el nombre de un formulario de la accin asociada y construye el Widget principal, a partir de l.
  */
  void setMainWidget();

protected:

  /**
  Inicializacin
  */
  void initForm();

  /**
  Captura evento cerrar
  */
  void closeEvent(QCloseEvent *e);

  /**
  Validacin de formulario.

  Invoca a la funcin "validateForm" del script "process" asociado al formulario, cuando
  se acepta el formulario y slo continua con el commit del registro cuando la funcin del
  script devuelve TRUE.
  */
  bool validateForm();

  /**
  Aceptacin de formulario.

  Invoca a la funcin "acceptedForm" del script "process" asociado al formulario, cuando
  se acepta el formulario y justo antes de hace el commit del registro.
  */
  void acceptedForm();

  /**
  Despus de fijar los cambios del buffer del registro actual.

  Invoca a la funcin "afterCommitBuffer" del script asociado al formulario,
  justo despus de hacer el commit del buffer del registro.
  */
  void afterCommitBuffer();

  /**
  Despues de fijar la transaccin.

  Invoca a la funcin "afterCommitTransaction" del script asociado al formulario,
  juesto despues de terminar la transaccin en curso aceptando.
  */
  void afterCommitTransaction();

  /**
  Cancelacin de formulario.

  Invoca a la funcin "canceledForm" del script "process" asociado al formulario, cuando se
  cancela el formulario.
  */
  void canceledForm();

  /**
  Boton Aceptar
  */
  QPushButton *pushButtonAccept;

  /**
  Boton Aceptar y continuar
  */
  QPushButton *pushButtonAcceptContinue;

  /**
  Boton Primero
  */
  QPushButton *pushButtonFirst;

  /**
  Boton Anterior
  */
  QPushButton *pushButtonPrevious;

  /**
  Boton Siguiente
  */
  QPushButton *pushButtonNext;

  /**
  Boton Ultimo
  */
  QPushButton *pushButtonLast;

public slots:

  /**
  Invoca a la funcin "init()" del script "process" asociado al formulario
  */
  void initScript();

  /**
  Se activa al pulsar el boton aceptar
  */
  virtual void accept();

  /**
  Se activa al pulsar el boton aceptar y contninuar
  */
  virtual void acceptContinue();

  /**
  Se activa al pulsar el botn cancelar
  */
  virtual void reject();

protected slots:

  /**
  Ir al primer anterior
  */
  virtual void firstRecord();

  /**
  Ir al registro anterior
  */
  virtual void previousRecord();

  /**
  Ir al registro siguiente
  */
  virtual void nextRecord();

  /**
  Ir al ultimo registro
  */
  virtual void lastRecord();

  /**
  Desactiva el botn cancelar
  */
  void disablePushButtonCancel();

private:

  /**
  Indica si se han aceptado los cambios
  */
  bool accepted;

  /**
  Indica si se debe mostrar el botn Aceptar y Continuar
  */
  bool showAcceptContinue_;

  /**
  Interface para scripts
  */
  FLFormRecordDBInterface *iface;

  /**
  Indica que se est intentando aceptar los cambios
  */
  bool accepting;

  /**
  Modo en el que inicialmente est el cursor
  */
  int initialModeAccess;

  /**
  Registra el nivel de anidamiento de transacciones en el que se entra al iniciar el formulario
  */
  int initTransLevel;
};

#endif
